Script.Load( "Data\\Script\\MapTools\\Main.lua" )

IncludeLocals("army_tools")
IncludeLocals("army_bridge")
IncludeLocals("army_defenders")
IncludeLocals("army_stone")
IncludeLocals("army_startBandits")
IncludeLocals("quest_bridge")
IncludeLocals("quest_ruinDefenders")
IncludeLocals("quest_destroyRuins")
IncludeLocals("quest_survive")
IncludeLocals("quest_defeat")
IncludeLocals("quest_stoneArmyDead")
IncludeLocals("quest_thief")
IncludeLocals("briefing_prelude")
IncludeLocals("briefing_builder0")
IncludeLocals("briefing_builder1")
IncludeLocals("briefing_builder2")
IncludeLocals("briefing_pilgrim")
IncludeLocals("briefing_survive")
IncludeLocals("briefing_thief")
IncludeLocals("briefing_survive_nobridge")
IncludeLocals("gameControl")
IncludeLocals("player2")
IncludeLocals("player7")

IncludeLocals("TradeBalancer")
IncludeLocals("Towerlimit")

IncludeLocals("GetRandom")
IncludeLocals("GetCirclePosition")
IncludeLocals("GetAngleBetween")
IncludeLocals("CopyTable")
IncludeLocals("EntityIDChangedHelper")
IncludeLocals("GetDistance")
IncludeLocals("IsEntityOfType")
IncludeLocals("IsValidPosition")
IncludeLocals("LuaObject")
IncludeLocals("TargetFilter")
IncludeLocals("TriggerFix")
IncludeLocals("UnlimitedArmy")



Cutscenes = {}
Cutscenes[INTROCUTSCENE] = "INTRO"
Cutscenes[THRESHOLDONECUTSCENE] = "ARMYBRIDGEDESTROYED"
Cutscenes[THRESHOLTWOCUTSCENE] = "BRIDGEBUILD"
Cutscenes[MISSIONCOMPLETECUTSCENE] = "MISSIONCOMPLETE"


IncludeLocals("Cutscene_" .. Cutscenes[INTROCUTSCENE])
IncludeLocals("Cutscene_" .. Cutscenes[THRESHOLDONECUTSCENE])
IncludeLocals("Cutscene_" .. Cutscenes[THRESHOLTWOCUTSCENE])
IncludeLocals("Cutscene_" .. Cutscenes[MISSIONCOMPLETECUTSCENE])
IncludeLocals("Cutscene_PREINTRO")


------------------------------------------------------------------------------
function InitDiplomacy()
    SetHostile(1,2)
	SetHostile(1,7)
    SetNeutral(1,5)

	end
------------------------------------------------------------------------------
function InitResources()
    end
------------------------------------------------------------------------------
function InitTechnologies()
	Logic.SetTechnologyState(1, Technologies.T_MarketStone, 0)
	Logic.SetTechnologyState(1, Technologies.T_MarketIron, 0)
	
	ForbidTechnology(Technologies.GT_Binocular)
	ForbidTechnology(Technologies.GT_Matchlock)
	ForbidTechnology(Technologies.GT_PulledBarrel)

	ForbidTechnology(Technologies.GT_Tactics)
	ForbidTechnology(Technologies.GT_Strategies)

	ForbidTechnology(Technologies.GT_ChainBlock)
	ForbidTechnology(Technologies.GT_Architecture)

	ForbidTechnology(Technologies.GT_Metallurgy)
	ForbidTechnology(Technologies.GT_Chemistry)

	ForbidTechnology(Technologies.GT_Printing)
	ForbidTechnology(Technologies.GT_Library)
    end
------------------------------------------------------------------------------
function InitWeatherGfxSets()
	SetupNormalWeatherGfxSet()
    end
------------------------------------------------------------------------------
function InitWeather()
	AddPeriodicSummer(600)
    end
------------------------------------------------------------------------------
function InitPlayerColorMapping()
    Display.SetPlayerColorMapping(1,PLAYER_COLOR)
    Display.SetPlayerColorMapping(2,NEPHILIM_COLOR)
    Display.SetPlayerColorMapping(3,NPC_COLOR)
    Display.SetPlayerColorMapping(4,NPC_COLOR)
    Display.SetPlayerColorMapping(5,NPC_COLOR)
    Display.SetPlayerColorMapping(6,NPC_COLOR)
	Display.SetPlayerColorMapping(7,ENEMY_COLOR1)

	Display.SetPlayerColorMapping(8,PLAYER_COLOR)
end
------------------------------------------------------------------------------
function FirstMapAction()
	TriggerFix.AllScriptsLoaded()
    -- String
	String.Init("CM02_01_HugeBridge")
	Mission_OnSaveGameLoaded_Reloadfunc = Mission_OnSaveGameLoaded
	Mission_OnSaveGameLoaded = function()
	Mission_OnSaveGameLoaded_Reloadfunc()
	if winterCounter ~= nil then
			MapLocal_StartCountDown(winterCounter)
	end
	end

    createPlayer2()
	createPlayer7()
	
	Score.Player[0] = {buildings=0, all=0}
	EntityIdChangedHelper.Init()

	math.randomseed(XGUIEng.GetSystemTime())
	
	TradeBlancerInit()
	ActivateTowerLimit(3)

    Logic.SetShareExplorationWithPlayerFlag(1, 4, 1)
    Logic.SetShareExplorationWithPlayerFlag(1, 3, 1)
	
	Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_CREATED,nil,"PoisenUnitCreated",1,nil,nil)
	Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_DESTROYED,nil,"PoisenUnitDestroied",1,nil,nil)

    StartCutscene("PREINTRO",beginChapterOne)
	
	Player1Units = {}
	gvTypesToTrack = {}

    for k,v in pairs(Entities) do
        if (string.find(k, "CU_", 1, true) or string.find(k, "PU_", 1, true)) and not string.find(k, "Soldier", 1, true) then
            gvTypesToTrack[v] = true;
        end;
    end;
	
	for type, _ in pairs(gvTypesToTrack) do
		local units = GetAllEntitiesOfPlayerOfType(1, type);
		for i = 1,table.getn(units) do
		  Player1Units[units[i]] = true;
		end;
	end;

    LocalMusic.UseSet = EUROPEMUSIC
	
	Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_CREATED, "", "ChestDeleter", 1, nil, nil)

	end
	
function GetAllEntitiesOfPlayerOfType(_player, _type)
    local units = {};
    local n, first = Logic.GetPlayerEntities(_player, _type, 1);
    if n > 0 then
        local entity = first;
        repeat
            table.insert(units, entity)
            entity = Logic.GetNextEntityOfPlayerOfType(entity);
        until entity == first;
    end;
    
    return units;
end;

function ChestDeleter()
	local entityIDs = Event.GetEntityID()
	if Logic.GetEntityTypeName(Logic.GetEntityType(entityIDs)) == "XD_ChestOpen" then
		Logic.DestroyEntity(entityIDs)
	end
end

function PoisenUnitCreated()
	local id = Event.GetEntityID();
	local type = Logic.GetEntityType(id);
	if Logic.EntityGetPlayer(id) == 1 then
		if gvTypesToTrack[type] then
		   -- füge in liste ein
		Player1Units[id] = true;
		end;
	end
end

function PoisenUnitDestroied()
	local id = Event.GetEntityID();
	if Logic.EntityGetPlayer(id) == 1 then
		Player1Units[id] = nil;
	end
end